<?php $__env->startSection('title', __('labels.backend.access.mac.management') . ' | ' . __('labels.backend.access.mac.edit')); ?>

<?php $__env->startSection('content'); ?>
<?php echo e(html()->modelForm($mac, 'PATCH', route('admin.auth.macs.update', $mac->id))->class('form-horizontal')->open()); ?>

    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        <?php echo app('translator')->get('labels.backend.access.mac.management'); ?>
                        <small class="text-muted"><?php echo app('translator')->get('labels.backend.access.mac.edit'); ?></small>
                    </h4>
                </div><!--col-->
            </div><!--row-->
            <!--row-->

            <hr />


<div class="row mt-4">
    <div class="col">
        <div class="form-group row">
            <?php echo e(html()->label(__('labels.backend.access.mac.table.mac'))
                ->class('col-md-2 form-control-label')
                ->for('name')); ?>


            <div class="col-md-10">
                <?php echo e($mac->mac_uuib); ?>

            </div><!--col-->
        </div><!--form-group-->

        <div class="form-group row">
            <?php echo e(html()->label(__('labels.backend.access.mac.table.disabled'))
                ->class('col-md-2 form-control-label')
                ->for('name')); ?>


            <div class="col-md-10">
            <div class="checkbox d-flex align-items-center">
                            <?php echo e(html()->label(
                                    html()->checkbox('disabled',($mac->disabled)?true:false)
                                          ->class('switch-input')
                                          ->id('status')
                                        . '<span class="switch-slider" data-checked="on" data-unchecked="off"></span>')
                                    ->class('switch switch-label switch-pill switch-primary mr-2')
                                ->for('status')); ?>

                        </div>
            </div><!--col-->
        </div><!--form-group-->

       
    </div><!--col-->
</div><!--row-->
</div><!--card-body-->



        <div class="card-footer">
            <div class="row">
                <div class="col">
                    <?php echo e(form_cancel(route('admin.auth.licensetype.index'), __('buttons.general.cancel'))); ?>

                </div><!--col-->

                <div class="col text-right">
                    <?php echo e(form_submit(__('buttons.general.crud.update'))); ?>

                </div><!--col-->
            </div><!--row-->
        </div><!--card-footer-->
    </div><!--card-->
<?php echo e(html()->closeModelForm()); ?>






<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    <?php echo app('translator')->get('labels.backend.access.license.management'); ?>
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4" id="lic_acc">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.name'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.refferuser'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.type'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.status'); ?></th>
                            <?php if($logged_in_user->isAdmin()): ?>
                            <th><?php echo app('translator')->get('labels.general.actions'); ?></th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($license->key_uuid); ?></td>
                                    <td>
                                    <?php echo e($license->licenseUserDetails->email ?? ''); ?>

                                    </td>
                                    <td>
                                    <?php echo e($license->licenseTypeDetails->name); ?>

                                    </td>
                                    <td>
                                    <?php echo e($license->status); ?>

                                    </td>
                                    
                                    <td><?php echo $__env->make('backend.license.actions', ['license' => $license], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                  
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    <?php echo $licenses->render(); ?>

                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/licenseriolabz/public_html/license-repo/resources/views/backend/macAddress/edit.blade.php ENDPATH**/ ?>