<?php $__env->startSection('title', app_name() . ' | '. __('labels.backend.access.mac.management')); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    <?php echo app('translator')->get('labels.backend.access.mac.management'); ?>
                </h4>
            </div><!--col-->
            <div class="col-sm-7 pull-right">
    <div class="input-group md-form form-sm form-1 pl-0">
        <div class="input-group-prepend">
            <span class="input-group-text purple lighten-3" id="basic-text1"><i class="fas fa-search text-white" aria-hidden="true"></i></span>
        </div>
        <form id="searchForm" action="<?php echo e(route('admin.auth.macs.index')); ?>" method="GET">
        <input style="width: 650px" class="form-control my-0 py-1" id="macsearch" value="<?php echo e(request()->input('search')); ?>" type="text" name="search" placeholder="Mac Address" aria-label="Search">
        </form>
    </div>
</div>
        </div><!--row-->
        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.access.mac.table.mac'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.mac.table.status'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.mac.table.disabled'); ?></th>
                            <th><?php echo app('translator')->get('labels.general.actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $macAddresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $macAddress): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($macAddress->mac_uuib); ?></td>
                                    <td><?php echo e($macAddress->status); ?></td>
                                    <td><?php echo e($macAddress->disabled ? 'yes' : 'no'); ?></td>
                                    <td><?php echo $__env->make('backend.macAddress.actions', ['mac' => $macAddress->id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    <?php echo $macAddresses->total(); ?> <?php echo e(trans_choice('labels.backend.access.license.licensetype.table.total', $macAddresses->total())); ?>

                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    <?php echo $macAddresses->render(); ?>

                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(function () {
      

    $("#macsearch").on('keyup',function(event){
     if(event.keyCode == 13){
         $("#searchForm").submit();
         return false;
     }
 });

        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/licenseriolabz/public_html/license-repo/resources/views/backend/macAddress/index.blade.php ENDPATH**/ ?>