<?php $__env->startSection('title', app_name() . ' | '. __('labels.backend.access.license.management')); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    <?php echo app('translator')->get('labels.backend.access.license.management'); ?>
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
            <div class="input-group md-form form-sm form-1 pl-0">
  <div class="input-group-prepend">
    <span class="input-group-text purple lighten-3" id="basic-text1"><i class="fas fa-search text-white"
        aria-hidden="true"></i></span>
  </div>
  <input class="form-control my-0 py-1" id="macsearch" type="text" placeholder="Search" aria-label="Search">
</div>
                <?php echo $__env->make('backend.license.header-button', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="float-left mt-4">
    <input id="searchByMacAddress" type="checkbox" name="searchByMacAddress">
    <label for="searchByMacAddress">Search by mac addresses</label>
  </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4" id="lic_acc">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.name'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.refferuser'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.type'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.license.table.status'); ?></th>
                            <?php if($logged_in_user->isAdmin()): ?>
                            <th><?php echo app('translator')->get('labels.general.actions'); ?></th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($license->key_uuid); ?></td>
                                    <td>
                                    <?php echo e($license->licenseUserDetails->email ?? ''); ?>

                                    </td>
                                    <td>
                                    <?php echo e($license->licenseTypeDetails->name); ?>

                                    </td>
                                    <td>
                                    <?php echo e($license->status); ?>

                                    </td>
                                    
                                    <td><?php echo $__env->make('backend.license.actions', ['license' => $license], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                    
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                  
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    <?php echo $licenses->render(); ?>

                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(function () {
      

    $("#macsearch").on('keyup',function(event){

     if(event.keyCode == 13){
        event.preventDefault();
                $.ajax({
                    url:      '<?php echo e(route('admin.auth.license.macindex')); ?>',
                    type:     "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        'searchKey': $(this).val(),
                        'searchByMacAddress': $('#searchByMacAddress').prop("checked") == true
                    },
                    success: function(data) {
                        $('#lic_acc').html(data.html);
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        alert('AJAX ERROR ! Check the console !');
                        console.error(errorThrown);
                    }
                });

                return false;
     }
 });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/licenseriolabz/public_html/license-repo/resources/views/backend/license/index.blade.php ENDPATH**/ ?>