<?php $__env->startSection('title', app_name() . ' | '. __('labels.backend.access.license.management')); ?>

<?php $__env->startSection('content'); ?>
<?php echo e(html()->form('POST', route('admin.auth.license.store'))->class('form-horizontal')->open()); ?>

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    <?php echo app('translator')->get('labels.backend.access.license.management'); ?>
                </h4>
            </div><!--col-->
            <div class="col-sm-7 ">
            <div class="btn-toolbar float-right">
                <span> <?php echo app('translator')->get('labels.backend.access.license.title'); ?> : <?php echo e(!empty($userDetail->credit) ? $userDetail->credit : 0); ?></span>
                </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
            <div class="form-group row">
                        <?php echo e(html()->label(__('validation.attributes.backend.access.license.name'))
                            ->class('col-md-2 form-control-label')
                            ->for('name')); ?>

                            <div class="col-md-10">
                                <?php if($logged_in_user->isStockz()): ?>
                                <?php echo e(html()->text('tags_license',$userList)
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.license.name'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus()); ?>

                                <?php else: ?>
                                <?php echo e(html()->text('tags_license')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.license.name'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus()); ?>

                                <?php endif; ?>

                            </div><!--col-->
                            </div><!--form-group-->
                    <div id ="subhtml">
                    <?php if($logged_in_user->isStockz()): ?>
                    <?php echo $__env->make('backend.license.userlicense', ['userDetails' => $userDetail,'licensekey' => $licensekey], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    </div>
                    </div>
            </div>
            </div>

    </div><!--card-body-->
</div><!--card-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(function () {
            var availableTags = <?php echo json_encode($userList, 15, 512) ?>;
    $( "#tags_license" ).autocomplete({
      source: availableTags
    });

    function tranferCredit() {
      alert("b");
    }

    $("#tags_license").on('keypress',function(event){
     if(event.which == 13){ 
        event.preventDefault();
                $.ajax({
                    url:      '<?php echo e(route('admin.auth.license.licensedetails')); ?>',
                    type:     "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        'userDetail': $(this).val(),
                    },
                    success: function(data) {
                        $('#subhtml').html(data.html);
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        alert('AJAX ERROR ! Check the console !');
                        console.error(errorThrown);
                    }
                });

                return false;
     }
 });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/licenseriolabz/public_html/license-repo/resources/views/backend/license/generatelicense.blade.php ENDPATH**/ ?>