<?php $__env->startSection('title', app_name() . ' | '. __('labels.backend.access.permission.management')); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    <?php echo app('translator')->get('labels.backend.access.permission.management'); ?>
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                <?php echo $__env->make('backend.auth.permission.includes.header-buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.access.permission.table.permissions'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.access.permission.table.type'); ?></th>
                           
                            <th><?php echo app('translator')->get('labels.general.actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(ucwords($permission->name)); ?></td>
                                    <td>
                                    <?php echo e($permission->guard_name); ?>

                                    </td>
                                    
                                    <td><?php echo $__env->make('backend.auth.permission.includes.actions', ['permission' => $permission], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    <?php echo $permissions->total(); ?> <?php echo e(trans_choice('labels.backend.access.roles.table.total', $permissions->total())); ?>

                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    <?php echo $permissions->render(); ?>

                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/licenseriolabz/public_html/license-repo/resources/views/backend/auth/permission/index.blade.php ENDPATH**/ ?>