@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.mac.management'))

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.mac.management')
                </h4>
            </div><!--col-->
            <div class="col-sm-7 pull-right">
    <div class="input-group md-form form-sm form-1 pl-0">
        <div class="input-group-prepend">
            <span class="input-group-text purple lighten-3" id="basic-text1"><i class="fas fa-search text-white" aria-hidden="true"></i></span>
        </div>
        <form id="searchForm" action="{{ route('admin.auth.macs.index') }}" method="GET">
        <input style="width: 650px" class="form-control my-0 py-1" id="macsearch" value="{{ request()->input('search') }}" type="text" name="search" placeholder="Mac Address" aria-label="Search">
        </form>
    </div>
</div>
        </div><!--row-->
        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>@lang('labels.backend.access.mac.table.mac')</th>
                            <th>@lang('labels.backend.access.mac.table.status')</th>
                            <th>@lang('labels.backend.access.mac.table.disabled')</th>
                            <th>@lang('labels.general.actions')</th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach($macAddresses as $macAddress)
                                <tr>
                                    <td>{{ $macAddress->mac_uuib }}</td>
                                    <td>{{ $macAddress->status }}</td>
                                    <td>{{ $macAddress->disabled ? 'yes' : 'no' }}</td>
                                    <td>@include('backend.macAddress.actions', ['mac' => $macAddress->id])</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {!! $macAddresses->total() !!} {{ trans_choice('labels.backend.access.license.licensetype.table.total', $macAddresses->total()) }}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {!! $macAddresses->render() !!}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

@push('after-scripts')
    <script>
        $(function () {
      

    $("#macsearch").on('keyup',function(event){
     if(event.keyCode == 13){
         $("#searchForm").submit();
         return false;
     }
 });

        });
    </script>
@endpush