@extends('backend.layouts.app')

@section('title', __('labels.backend.access.mac.management') . ' | ' . __('labels.backend.access.mac.edit'))

@section('content')
{{ html()->modelForm($mac, 'PATCH', route('admin.auth.macs.update', $mac->id))->class('form-horizontal')->open() }}
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        @lang('labels.backend.access.mac.management')
                        <small class="text-muted">@lang('labels.backend.access.mac.edit')</small>
                    </h4>
                </div><!--col-->
            </div><!--row-->
            <!--row-->

            <hr />


<div class="row mt-4">
    <div class="col">
        <div class="form-group row">
            {{ html()->label(__('labels.backend.access.mac.table.mac'))
                ->class('col-md-2 form-control-label')
                ->for('name') }}

            <div class="col-md-10">
                {{ $mac->mac_uuib }}
            </div><!--col-->
        </div><!--form-group-->

        <div class="form-group row">
            {{ html()->label(__('labels.backend.access.mac.table.disabled'))
                ->class('col-md-2 form-control-label')
                ->for('name') }}

            <div class="col-md-10">
            <div class="checkbox d-flex align-items-center">
                            {{ html()->label(
                                    html()->checkbox('disabled',($mac->disabled)?true:false)
                                          ->class('switch-input')
                                          ->id('status')
                                        . '<span class="switch-slider" data-checked="on" data-unchecked="off"></span>')
                                    ->class('switch switch-label switch-pill switch-primary mr-2')
                                ->for('status') }}
                        </div>
            </div><!--col-->
        </div><!--form-group-->

       
    </div><!--col-->
</div><!--row-->
</div><!--card-body-->



        <div class="card-footer">
            <div class="row">
                <div class="col">
                    {{ form_cancel(route('admin.auth.licensetype.index'), __('buttons.general.cancel')) }}
                </div><!--col-->

                <div class="col text-right">
                    {{ form_submit(__('buttons.general.crud.update')) }}
                </div><!--col-->
            </div><!--row-->
        </div><!--card-footer-->
    </div><!--card-->
{{ html()->closeModelForm() }}



{{-- Licenses --}}

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.license.management')
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4" id="lic_acc">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>@lang('labels.backend.access.license.table.name')</th>
                            <th>@lang('labels.backend.access.license.table.refferuser')</th>
                            <th>@lang('labels.backend.access.license.table.type')</th>
                            <th>@lang('labels.backend.access.license.table.status')</th>
                            @if ($logged_in_user->isAdmin())
                            <th>@lang('labels.general.actions')</th>
                            @endif
                        </tr>
                        </thead>
                        <tbody>
                            @foreach($licenses as $license)
                                <tr>
                                    <td>{{ $license->key_uuid }}</td>
                                    <td>
                                    {{ $license->licenseUserDetails->email ?? '' }}
                                    </td>
                                    <td>
                                    {{ $license->licenseTypeDetails->name }}
                                    </td>
                                    <td>
                                    {{ $license->status }}
                                    </td>
                                    
                                    <td>@include('backend.license.actions', ['license' => $license])</td>
                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                  
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {!! $licenses->render() !!}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection
