@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.license.licensetype.management'))

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.license.licensetype.management')
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                @include('backend.license.licensetype.header-button')
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>@lang('labels.backend.access.license.licensetype.table.name')</th>
                            <th>@lang('labels.backend.access.license.licensetype.table.duration')</th>
                            <th>@lang('labels.backend.access.license.licensetype.table.status')</th>
                            <th>@lang('labels.backend.access.license.licensetype.table.type')</th>
                            <th>@lang('labels.general.actions')</th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach($licenseTypes as $licenseType)
                                <tr>
                                    <td>{{ ucwords($licenseType->name) }}</td>
                                    <td>
                                    {{ $licenseType->duration }}
                                    </td>
                                    <td>
                                    {{ $licenseType->status }}
                                    </td>
                                    <td>
                                    {{ $licenseType->licence_type }}
                                    </td>
                                    <td>@include('backend.license.licensetype.actions', ['licenseType' => $licenseType])</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {!! $licenseTypes->total() !!} {{ trans_choice('labels.backend.access.license.licensetype.table.total', $licenseTypes->total()) }}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {!! $licenseTypes->render() !!}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection
