@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.license.management'))

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.license.ip')
                </h4>
            </div><!--col-->

        </div><!--row-->

        <div class="row mt-4" id="lic_acc">
            <div class="col">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>@lang('labels.backend.access.license.table.name')</th>
                            <th>@lang('labels.backend.access.license.table.mac')</th>
                            <th>@lang('labels.backend.access.license.table.ip')</th>
                            <th>@lang('labels.backend.access.license.table.status')</th>
                           
                        </tr>
                        </thead>
                        <tbody>
                            @foreach($ips as $Ip)
                                <tr>
                                    <td>{{ $Ip->license->key_uuid }}</td>
                                    <td>
                                    {{ $Ip->macDetail->mac_uuib }}
                                    </td>
                                    <td>
                                    {{ $Ip->ipAddress }}
                                    </td>
                                    <td>
                                    {{ $Ip->apiStatus }}
                                    </td>
                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                  
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {!! $ips->render() !!}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

