@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.license.management'))

@section('content')
{{ html()->form('POST', route('admin.auth.license.store'))->class('form-horizontal')->open() }}
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.license.management')
                </h4>
            </div><!--col-->
            <div class="col-sm-7 ">
            <div class="btn-toolbar float-right">
                <span> @lang('labels.backend.access.license.title') : {{ !empty($userDetail->credit) ? $userDetail->credit : 0 }}</span>
                </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
            <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.license.name'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}
                            <div class="col-md-10">
                                @if ($logged_in_user->isStockz())
                                {{ html()->text('tags_license',$userList)
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.license.name'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }}
                                @else
                                {{ html()->text('tags_license')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.license.name'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }}
                                @endif

                            </div><!--col-->
                            </div><!--form-group-->
                    <div id ="subhtml">
                    @if ($logged_in_user->isStockz())
                    @include('backend.license.userlicense', ['userDetails' => $userDetail,'licensekey' => $licensekey])
                    @endif
                    </div>
                    </div>
            </div>
            </div>

    </div><!--card-body-->
</div><!--card-->
@endsection

@push('after-scripts')
    <script>
        $(function () {
            var availableTags = @json($userList);
    $( "#tags_license" ).autocomplete({
      source: availableTags
    });

    function tranferCredit() {
      alert("b");
    }

    $("#tags_license").on('keypress',function(event){
     if(event.which == 13){ 
        event.preventDefault();
                $.ajax({
                    url:      '{{route('admin.auth.license.licensedetails')}}',
                    type:     "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        'userDetail': $(this).val(),
                    },
                    success: function(data) {
                        $('#subhtml').html(data.html);
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        alert('AJAX ERROR ! Check the console !');
                        console.error(errorThrown);
                    }
                });

                return false;
     }
 });

        });
    </script>
@endpush
