@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.credit.adjust'))

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.credit.adjust')
                </h4>
            </div><!--col-->
            <div class="col-sm-7 ">
            <div class="btn-toolbar float-right">
                <span> @lang('labels.backend.access.credit.title') : {{ !empty($userDetail->credit) ? $userDetail->credit : 0 }}</span>
                </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
            <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.users.username'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                        {{ !empty($userExist->user) ? $userExist->user->first_name." ".$userExist->user->last_name: 0 }}
            
                        </div><!--col-->
                        
                    </div><!--form-group-->
                    <div class="form-group row">
                        {{ html()->label(__('validation.attributes.backend.access.credit.credit'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                        {{ !empty($userExist) ? $userExist->credit: 0 }}
            
                        </div><!--col-->
                        
                    </div><!--form-group-->
            </div>
            </div>
            <hr>
            {{ html()->form('POST', route('admin.auth.credit.store', $userExist->user_id))->class('form-horizontal')->open() }}
            <div class="row mt-4 mb-4">
                    <div class="col">
                        <div class="form-group row">
                            {{ html()->label(__('validation.attributes.backend.access.credit.amountTransfer'))->class('col-md-2 form-control-label')->for('first_name') }}

                            <div class="col-md-10">
                                {{ html()->number('amount')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.credit.amountTransfer'))
                                    ->attribute('maxlength', 191)
                                    ->required()
                                    ->autofocus() }}
                            </div><!--col-->
                         </div><!--form-group-->
                        
                        
                        <div class="form-group row">
                            {{ html()->label(__('validation.attributes.backend.access.credit.transactionPassword'))->class('col-md-2 form-control-label')->for('first_name') }}

                            <div class="col-md-10">
                                {{ html()->password('transactionpassword')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.credit.transactionPassword'))
                                    ->attribute('maxlength', 191)
                                    ->required()
                                    ->autofocus() }}
                                    {{ html()->hidden('credittype','adjust')
                                    ->class('form-control')
                                     }}    
                            </div><!--col-->
                        </div><!--form-group-->
            </div>            

        </div><!--card-body-->
</div><!--card-->

<div class="card-footer clearfix">
                <div class="row">
                    <div class="col">
                        {{ form_cancel(route('admin.auth.credit.index'), __('buttons.general.cancel')) }}
                    </div><!--col-->

                    <div class="col text-right">
                        {{ form_submit(__('buttons.general.crud.create')) }}
                    </div><!--col-->
                </div><!--row-->
            </div><!--card-footer-->
        </div><!--card-->
    {{ html()->form()->close() }}


@endsection        