<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\LicenseMacMapping;

/**
 * Class Role.
 */
class MacDetail extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'mac_details';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['userId', 'mac_uuib', 'status', 'disabled'];

    public function licensemacMapping()
    {
        return $this->hasMany('App\Models\LicenseMacMapping');
    }

    public function licenseLedger()
    {
        return $this->hasMany('App\Models\LicenseLedger');
    }

    public function scopeSearch($query, $search)
    {
        if ($search) {
            $query->where('mac_uuib', 'LIKE', "%$search%");
        }

        return $query;
    }

    public function mappings()
    {
        return $this->hasMany(LicenseMacMapping::class, 'macDetailid', 'id');
    }

    public function licenses()
    {
        return $this->belongsToMany(License::class, 'key_mac_mapping', 'macDetailId', 'lincensekeyId');
    }
}
