<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Role.
 */
class License extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'lincense_keys';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['key_uuid','licenseTypeId','licenseUserId','status','refferalUserId'];

    public function licenseTypeDetails()
    {
        return $this->belongsTo('App\Models\LicenseType','licenseTypeId','id');
    }

    public function licenseUserDetails()
    {
        return $this->belongsTo('App\Models\Auth\User','licenseUserId','id');
    }

    public function licenseRefferUserDetails() {
        return $this->belongsTo('App\Models\Auth\User','refferalUserId','id');
    }

    public function licensemacMapping()
    {
        return $this->hasMany('App\Models\LicenseMacMapping','lincensekeyId','id');
    }

    public function licenseLedger()
    {
        return $this->hasMany('App\Models\LicenseLedger');
    }

}
