<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Role.
 */
class UserDetail extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'user_details';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['user_id','parent'];

    public function user()
    {
        return $this->belongsTo('App\Models\Auth\User','user_id','id');
    }

    public function parentDetails()
    {
        return $this->belongsTo('App\Models\Auth\User','parent','id');
    }
}
