<?php

namespace App\Http\Middleware;

use Closure;

class PublicApiAuthenticationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ($this->authenticate($request)) {
            return $next($request);
        }

        return abort(401);
    }

    public function authenticate($request)
    {
        return $request->hasHeader('Authorization')
        && config('license.authKey') === $request->header('Authorization'); 
    }
}
