<?php

namespace App\Http\Controllers\Backend\License;

use App\Models\Auth\{User, UserDetail};
use App\Models\{LicenseType,License, MacDetail};
use App\Http\Controllers\Controller;
use App\Events\Backend\Auth\User\UserDeleted;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\UserRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Http\Requests\Backend\Auth\User\StoreUserRequest;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Http\Requests\Backend\Auth\User\UpdateUserRequest;
use App\Http\Controllers\Backend\helper\UserFunction;
use App\Repositories\Backend\License\LicenseRepository;
use Illuminate\Http\Request;
use App\Exceptions\GeneralException;

/**
 * Class UserController.
 */
class LicenseController extends Controller
{
    /**
     * @var creditRepository
     */
    protected $licenseRepository;

    /**
     * @var UserFunction
     */
    protected $userFunction;

    /**
     * UserController constructor.
     *
     * @param LicenseRepository $licenseRepository
     */
    public function __construct(LicenseRepository $licenseRepository, UserFunction $userFunction)
    {
        
        $this->licenseRepository = $licenseRepository;
        $this->userFunction = $userFunction;
        $this->middleware(['role:superAdmin'], ['only' => ['index','create']]);
    }

   
    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function index(Request $request,User $user)
    {

        return view('backend.license.licensetype.index')
        ->withLicenseTypes($this->licenseRepository->getActivePaginated(25, 'id', 'desc'));
    }

    /**
     * @param Request $request
     *
     * @throws \Exception
     * @return mixed
     */
    public function create(Request $request)
    {
        $licensekey = config('license.licensekey');
        return view("backend.license.licensetype.create")->with(compact('licensekey'));

    }

    /**
     * @param Request $request
     *
     * @throws \Throwable
     * @return mixed
     */
    public function store(Request $request)
    {
        $statusChecked = ($request->has('status'))?'active':'inactive';
        $data = $request->only(
            'name',
            'duration',
            'licensekey'
        );
        $data['status']=$statusChecked;
        $this->licenseRepository->create($data);
        
        return redirect()->route("admin.auth.licensetype.index")->withFlashSuccess(__('alerts.backend.users.created'));
    }

     /**
     * @param ManageUserRequest    $request
     * @param RoleRepository       $roleRepository
     * @param PermissionRepository $permissionRepository
     * @param User                 $user
     *
     * @return mixed
     */
    public function edit(LicenseType $licenseType)
    {
        $licensekey = config('license.licensekey');
        return view('backend.license.licensetype.edit')
            ->withlicenseTypes($licenseType)->with(compact('licensekey'));
    }

    /**
     * @param UpdateUserRequest $request
     * @param User              $user
     *
     * @throws \App\Exceptions\GeneralException
     * @throws \Throwable
     * @return mixed
     */
    public function update(Request $request, LicenseType $licenseType)
    {
        $statusChecked = ($request->has('status'))?'active':'inactive';
        $data = $request->only(
            'name',
            'duration',
            'licensekey'
        );
        $data['status']=$statusChecked;
        $this->licenseRepository->update($licenseType, $data);
        return redirect()->route('admin.auth.licensetype.index')->withFlashSuccess(__('alerts.backend.licensetype.updated'));
    }

    /**
     * @param Request $request
     * @param Role              $role
     *
     * @throws \Exception
     * @return mixed
     */
    public function destroy(Request $request, LicenseType $licenseType)
    {  
        $this->licenseRepository->deleteById($licenseType->id);
        return redirect()->route('admin.auth.licensetype.index')->withFlashSuccess(__('alerts.backend.licensetype.deleted'));
    }

    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function generatelicense(Request $request,User $user)
    {
        
        if(auth()->user()->roles[0]->id==1){
        $userList = User::pluck('email')->toArray();
        }
        
        if(auth()->user()->roles[0]->id==2){
        $userList = [auth()->user()->email];    
        $userListParent = UserDetail::with(['user'])->where([['parent',auth()->user()->id],['status','active']])->get()->pluck('user.email')->toArray();
        $userList = array_merge($userList, $userListParent);
        }
        if(auth()->user()->roles[0]->id==3){
            $userList = auth()->user()->email;
        }
        $licensekey = (auth()->user()->roles[0]->id >2)?LicenseType::where('licence_type','permanent')->pluck('name','id'):LicenseType::where('status','active')->pluck('name','id');
        $roleType = auth()->user()->roles[0]->name;
        $userDetails = UserDetail::with(['user','parentDetails'])->where([['user_id',auth()->user()->id],['status','active']])->first();
        return view('backend.license.generatelicense')->withUserDetail($userDetails)->with(compact('roleType','userList','licensekey'));
    }

    /**
     * @param Request $request
     *
     * @throws \Exception
     * @return mixed
     */
    public function licensedetails(Request $request)
    {
        $param = $request->only('userDetail');
        $sub_selectedUser = '';
        $licensekey = (auth()->user()->roles[0]->id >2)?LicenseType::where('licence_type','permanent')->pluck('name','id'):LicenseType::where('status','active')->pluck('name','id');
        $userDetails = $this->licenseRepository->getUserParticularLicense($param);
        $view = view("backend.license.userlicense",compact('userDetails','licensekey'))->render();
        return response()->json(['html'=>$view]);

    }

    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function storelicense(Request $request)
    {
        $param = $request->only('tags_license','licensekey');
        $storeDetails = $this->licenseRepository->setStoreLicense($param);
        return redirect()->route('admin.auth.license.index')->withFlashSuccess(__('alerts.backend.license.updated'));
    }

    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function licenseindex(Request $request)
    {

        return view('backend.license.index')
        ->withLicenses($this->licenseRepository->getActiveLicensePaginated(25, 'id', 'desc'));
    }

    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function licenseMacindex(Request $request)
    {
	$search = $request->get('searchKey');

        $searchByMacAddress = $request->get('searchByMacAddress');

        if ($searchByMacAddress == "true") {
            $macDetail = MacDetail::where('mac_uuib', $search);
            $macDetail = $macDetail->first();
            $licenses = $this->licenseRepository->getLicenseMac($macDetail);
        } else {
            $licenses = $this->licenseRepository->getLicenseByKey($search);
        }

        $view = view("backend.license.indexmac")
        ->withLicenses($licenses)->render();
        return response()->json(['html'=>$view]);
   }

    public function licenseedit(License $license)
    {
        //dd($license->licensemacMapping[0]->macDetail->mac_uuib);
        //dd($license->licenseTypeDetails);
        return view('backend.license.editlicensemac')
            ->withlicenses($license);
    }

    public function licenseupdate(License $license, Request $request)
    {
        $data['licenseId'] = $license->id;
        $data['licensestatus'] = $request->input('status');
        $data['mac'] = $request->input('licensemacs');
        $this->licenseRepository->setLicenseMacUpdate($data);
        return redirect()->route('admin.auth.license.index')->withFlashSuccess(__('alerts.backend.license.updated'));
    }

    /**
     * @param Request $request
     *
     * @return mixed
     */
    public function ipAddressindex($macId)
    {

        return view('backend.license.ipAddress')
        ->withIps($this->licenseRepository->getActiveIpPaginated(25, 'id', 'desc',$macId));
    }

    
}
