<?php

namespace App\Http\Controllers\Backend\Auth;

use App\Models\MacDetail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MacAddressController extends Controller
{
    public function index(Request $request)
    {
        $macAddresses = MacDetail::search($request->search)
            ->latest()
            ->paginate();

        return view('backend.macAddress.index')
            ->withMacAddresses($macAddresses);
    }

    public function edit(MacDetail $mac, Request $request)
    {
        $licenses = $mac
            ->licenses()
            ->latest()
            ->paginate();

        return view('backend.macAddress.edit')
            ->withLicenses($licenses)
            ->withMac($mac);
    }

    public function update(MacDetail $mac, Request $request)
    {
        $mac->update(['disabled' => (bool) $request->disabled]);

        return redirect()
            ->route('admin.auth.macs.index')
            ->withFlashSuccess(__('alerts.backend.macs.updated'));
    }
}
